clear();
clc();
close all;                              											%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
aWERTETABELLE(1,:)  =["Xi", 0, 1,  2, 3,  4, 5, 6];
aWERTETABELLE(2,:)  =["Yi", 1, 2,  0, 1, -1, 2, 1];
iX                  = 3.5;             												%Stelle an x an der Funktionswert der Interpolation ausgerechnet werden soll
sKommastellenDouble = '%.8f';          												%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_WERTE = size(aWERTETABELLE,2)-1;                                            %Gibt die Anzahl der Spalten zurück (Parameter 2) abzüglich 1 (Der Bezeichner der Wertereihe)

%INITIALISIERUNG-------------------------------------------------------------------
aNEVAITK_TEXT(1,:)=["Xi",strcat("Fi=Pi0(",num2str(iX),")")];
for(i=1:1:iANZAHL_WERTE-1)                                                          %Erzeugung der dynamischen Kopfzeile
    aNEVAITK_TEXT(1,2+i)=strcat("Pi",num2str(i),"(",num2str(iX),")");
end
aNEVAITK_TEXT(2:(2*iANZAHL_WERTE),1:((iANZAHL_WERTE)+1))=[""];                      %Auffüllung des Arrays mit leeren Strings
aNEVAITK(1,:)=["Xi",strcat("Fi=Pi0(",num2str(iX),")")];
for(i=1:1:iANZAHL_WERTE-1)                                                          %Erzeugung der dynamischen Kopfzeile
    aNEVAITK(1,2+i)=strcat("Pi",num2str(i),"(",num2str(iX),")");
end
aNEVAITK(2:(2*iANZAHL_WERTE),1:((iANZAHL_WERTE)+1))=[""];                      		%Auffüllung des Arrays mit leeren Strings

%NEVILLE_AITKEN_SCHEMA------------------------------------------------------------
for(i=0:1:iANZAHL_WERTE-1)                                                          %Übertragung der Wertetabelle in die differierenden-Differenzen-Tabelle
    aNEVAITK_TEXT(2*(i+1),1)=strcat("X",num2str(i));
    aNEVAITK_TEXT(2*(i+1),2)=strcat("P",num2str(i),"0(",num2str(iX),")");
end
for(i=0:1:iANZAHL_WERTE-2)                                                          %Definiert das Durchlaufen der Berechnungszeilen
    for(k=1:1:iANZAHL_WERTE-i-1)                                                    %Definiert das Durchlaufen der Berechnungsspalten
        aNEVAITK_TEXT((2*i)+k+2,k+2)=strcat("P",num2str(i+1),num2str(k-1),"(",num2str(iX),") + ","(X",num2str(i+k),"-X)/(X",num2str(i+k),"-X",num2str(i),") * (P",num2str(i),num2str(k-1),"(",num2str(iX),")","-P",num2str(i+1),num2str(k-1),"(",num2str(iX),")",")");
    end
end
disp(aNEVAITK_TEXT);

%BERECHNUNG_DES_NEVILLE_AITKEN_SCHEMA----------------------------------------------
for(i=1:1:iANZAHL_WERTE)                                                            %Übertragung der Wertetabelle in die differierenden-Differenzen-Tabelle
    aNEVAITK(2*i,1)=aWERTETABELLE(1,i+1);
    aNEVAITK(2*i,2)=aWERTETABELLE(2,i+1);
end
for(k=1:1:iANZAHL_WERTE-1)                                                          %Definiert das Durchlaufen der Berechnungsspalten
    for(i=0:1:iANZAHL_WERTE-k-1)                                                    %Definiert das Durchlaufen der Berechnungszeilen
        aNEVAITK((2*i)+k+2,k+2)=num2str( str2double(aNEVAITK((2*(i+1))+k+1,(k-1)+2)) + (((str2double(aNEVAITK((2*(i+k))+2,1))-iX)/(str2double(aNEVAITK((2*(i+k))+2,1))-str2double(aNEVAITK((2*i)+2,1)))) * (str2double(aNEVAITK((2*i)+k+1,(k-1)+2)) - str2double(aNEVAITK((2*(i+1))+k+1,(k-1)+2)))) ,sKommastellenDouble);   
    end
end
disp(aNEVAITK);

%ERGEBNISPLOT----------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X=min(str2double(aWERTETABELLE(1,2:end))):(max(str2double(aWERTETABELLE(1,2:end)))-min(str2double(aWERTETABELLE(1,2:end))))/Inkrement:max(str2double(aWERTETABELLE(1,2:end)));
scatter(aWERTETABELLE(1,2:end),aWERTETABELLE(2,2:end),100,'o');
hold on;                                %Warten bis zur Plotausgabe
Offset=0.1;
text(str2double(aWERTETABELLE(1,2:end))+Offset,str2double(aWERTETABELLE(2,2:end))+Offset,cellstr(strcat(aWERTETABELLE(1,2:end)," | ",aWERTETABELLE(2,2:end))));
hold on;                                %Warten bis zur Plotausgabe
scatter(iX,str2double(aNEVAITK((size(aNEVAITK,1)/2)+1,size(aNEVAITK,2))),100,'x');
text(iX+Offset,str2double(aNEVAITK((size(aNEVAITK,1)/2)+1,size(aNEVAITK,2)))+Offset,cellstr(strcat(num2str(iX)," | ",aNEVAITK((size(aNEVAITK,1)/2)+1,size(aNEVAITK,2)))));
hold on;                                %Warten bis zur Plotausgabe
plot(X,xACHSE(X),'color','black');
grid on;                                %Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE aNEVAITK aNEVAITK_TEXT                              %Workspace aufräumen